function [SS_stoch_mut] = make_SS_stoch_mut(SS_eq, nves, par)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%This script stochastically computes a steady state matrix (nsyt x nves)
%for a model with a combination of WT and mutant syts

%Input:
%SS_eq_cell - Steady state distribution of vesicle states output function: steady_state_newmethod_mutant
%nves - number of vesicles
%par - model parameters

%output
%SS_stoch - steady state matrix for nsyt x nves

maxCross = par(9);
nSyts = par(8);
n_WT= par(11);
n_mut = nSyts - n_WT;


cum_SS = cumsum(SS_eq);


if maxCross > nSyts
    maxCross = nSyts;
end

[~, states] = indCal_all_mutant(n_WT, n_mut, maxCross);

p_draw = rand(1,nves);

SS_stoch_mut = zeros(n_WT+n_mut, nves);

for k = 1:nves
    p_ves = p_draw(k);
    
    SS_ind = find(p_ves<=cum_SS, 1, 'first');
    
    ves_state = states(SS_ind,:);
    
    SS_stoch_mut(1:ves_state(1),k) = 11;
    SS_stoch_mut((ves_state(1)+1):(ves_state(1)+ves_state(3)),k) = 1;
    SS_stoch_mut((ves_state(1)+ves_state(3)+1):(ves_state(1) + ves_state(3)+ves_state(5)),k) = 10;

    SS_stoch_mut((n_WT+1):ves_state(2),k) = 11;
    SS_stoch_mut((n_WT+ves_state(2)+1):(n_WT + ves_state(2)+ves_state(4)),k) = 1;
    SS_stoch_mut((n_WT+ves_state(2)+ves_state(4)+1):(n_WT + ves_state(2) + ves_state(4)+ves_state(6)),k) = 10;
    
end
    